#### Statistical Analysis ####
#Script by Charlie Cornwallis, Julian Melgar & Mads Schou

#*******************************************************************************
#Preliminaries ----
#*******************************************************************************
pacman::p_load("dplyr","doBy","languageR","QuantPsyc","Hmisc","doBy","car","gplots","sciplot","ape",
               "coda","MCMCglmm","mcmcplots","metafor","phytools","ggplot2","tidyr","PerformanceAnalytics",
               "arm","wesanderson","openxlsx","stringdist")

load("SI_Data.RData")

#*******************************************************************************
#Model settings ----
#*******************************************************************************
nitts<-110000
burn<-10000
thin<-100

nitts<-3000000
burn<-1000000
thin<-2000

#*******************************************************************************
#Model 1: Male reproductive success: number of eggs produced ----
#*******************************************************************************
prior1 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002)))
#prior1 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002)))
#prior1 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=diag(2), nu=0.002)))

#Main effects
M1.1.1<-MCMCglmm(stand_eggs_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care, 
                 random=~year+camp,
                 family ="poisson", data = Eggs[Eggs$sex == "Male",], prior = prior1, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M1.1.2<-MCMCglmm(stand_eggs_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care, 
                 random=~year+camp,
                 family ="poisson", data = Eggs[Eggs$sex == "Male",], prior = prior1, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M1.1.3<-MCMCglmm(stand_eggs_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care, 
                 random=~year+camp,
                 family ="poisson", data = Eggs[Eggs$sex == "Male",], prior = prior1, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Two way interactions
M1.2.1<-MCMCglmm(stand_eggs_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2, 
                 random=~year+camp,
                 family ="poisson", data = Eggs[Eggs$sex == "Male",], prior = prior1, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M1.2.2<-MCMCglmm(stand_eggs_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2, 
                 random=~year+camp,
                 family ="poisson", data = Eggs[Eggs$sex == "Male",], prior = prior1, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M1.2.3<-MCMCglmm(stand_eggs_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2, 
                 random=~year+camp,
                 family ="poisson", data = Eggs[Eggs$sex == "Male",], prior = prior1, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Check convergence of models
M1.1.Sol<-mcmc.list(M1.1.1$Sol,M1.1.2$Sol,M1.1.3$Sol)
plot(M1.1.Sol)
M1.1.VCV<-mcmc.list(M1.1.1$VCV,M1.1.2$VCV,M1.1.3$VCV)
plot(M1.1.VCV)
#Point est. above 1.2 indicate convergence problems
gelman.diag(M1.1.Sol)
gelman.diag(M1.1.VCV, multivariate = FALSE)

M1.2.Sol<-mcmc.list(M1.2.1$Sol,M1.2.2$Sol,M1.2.3$Sol)
plot(M1.2.Sol)
M1.2.VCV<-mcmc.list(M1.2.1$VCV,M1.2.2$VCV,M1.2.3$VCV)
plot(M1.2.VCV)
gelman.diag(M1.2.Sol)
gelman.diag(M1.2.VCV, multivariate = FALSE)

#*******************************************************************************
#Model 2: Female reproductive success: number of eggs produced ----
#*******************************************************************************
prior2 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002)))
#prior2 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002)))
#prior2 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=diag(2), nu=0.002)))

#Main effects
M2.1.1<-MCMCglmm(stand_eggs_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care, 
                 random=~year+camp,
                 family ="poisson", data = Eggs[Eggs$sex == "Female",], prior = prior2, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M2.1.2<-MCMCglmm(stand_eggs_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care, 
                 random=~year+camp,
                 family ="poisson", data = Eggs[Eggs$sex == "Female",], prior = prior2, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M2.1.3<-MCMCglmm(stand_eggs_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care, 
                 random=~year+camp,
                 family ="poisson", data = Eggs[Eggs$sex == "Female",], prior = prior2, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Two way interactions
M2.2.1<-MCMCglmm(stand_eggs_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2, 
                 random=~year+camp,
                 family ="poisson", data = Eggs[Eggs$sex == "Female",], prior = prior2, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M2.2.2<-MCMCglmm(stand_eggs_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2, 
                 random=~year+camp,
                 family ="poisson", data = Eggs[Eggs$sex == "Female",], prior = prior2, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M2.2.3<-MCMCglmm(stand_eggs_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2, 
                 random=~year+camp,
                 family ="poisson", data = Eggs[Eggs$sex == "Female",], prior = prior2, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Check convergence of models
M2.1.Sol<-mcmc.list(M2.1.1$Sol,M2.1.2$Sol,M2.1.3$Sol)
plot(M2.1.Sol)
M2.1.VCV<-mcmc.list(M2.1.1$VCV,M2.1.2$VCV,M2.1.3$VCV)
plot(M2.1.VCV)
#Point est. above 1.2 indicate convergence problems
gelman.diag(M2.1.Sol)
gelman.diag(M2.1.VCV, multivariate = FALSE)

M2.2.Sol<-mcmc.list(M2.2.1$Sol,M2.2.2$Sol,M2.2.3$Sol)
plot(M2.2.Sol)
M2.2.VCV<-mcmc.list(M2.2.1$VCV,M2.2.2$VCV,M2.2.3$VCV)
plot(M2.2.VCV)
gelman.diag(M2.2.Sol)
gelman.diag(M2.2.VCV, multivariate = FALSE)

#*******************************************************************************
#Model 3:  Male reproductive success: number of chicks produced ----
#*******************************************************************************
prior3 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002)))
#prior3 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002)))
#prior3 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=diag(2), nu=0.002)))

#Main effects
M3.1.1<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care, 
                 random=~year+camp,
                 family ="poisson", data = Chicks[Chicks$sex == "Male",], prior = prior3, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M3.1.2<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care, 
                 random=~year+camp,
                 family ="poisson", data = Chicks[Chicks$sex == "Male",], prior = prior3, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M3.1.3<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care, 
                 random=~year+camp,
                 family ="poisson", data = Chicks[Chicks$sex == "Male",], prior = prior3, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Two way interactions
M3.2.1<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2,
                 random=~year+camp,
                 family ="poisson", data = Chicks[Chicks$sex == "Male",], prior = prior3, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M3.2.2<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2, 
                 random=~year+camp,
                 family ="poisson", data = Chicks[Chicks$sex == "Male",], prior = prior3, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M3.2.3<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2, 
                 random=~year+camp,
                 family ="poisson", data = Chicks[Chicks$sex == "Male",], prior = prior3, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Check convergence of models
M3.1.Sol<-mcmc.list(M3.1.1$Sol,M3.1.2$Sol,M3.1.3$Sol)
plot(M3.1.Sol)
M3.1.VCV<-mcmc.list(M3.1.1$VCV,M3.1.2$VCV,M3.1.3$VCV)
plot(M3.1.VCV)
#Point est. above 1.2 indicate convergence problems
gelman.diag(M3.1.Sol)
gelman.diag(M3.1.VCV, multivariate = FALSE)

M3.2.Sol<-mcmc.list(M3.2.1$Sol,M3.2.2$Sol,M3.2.3$Sol)
plot(M3.2.Sol)
M3.2.VCV<-mcmc.list(M3.2.1$VCV,M3.2.2$VCV,M3.2.3$VCV)
plot(M3.2.VCV)
gelman.diag(M3.2.Sol)
gelman.diag(M3.2.VCV, multivariate = FALSE)


#*******************************************************************************
#Model 4:  Female reproductive success: number of chicks produced ----
#*******************************************************************************
prior4 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002)))
#prior4 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002)))
#prior4 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=diag(2), nu=0.002)))

#Main effects
M4.1.1<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care, 
                 random=~year+camp,
                 family ="poisson", data = Chicks[Chicks$sex == "Female",], prior = prior4, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M4.1.2<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care, 
                 random=~year+camp,
                 family ="poisson", data = Chicks[Chicks$sex == "Female",], prior = prior4, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M4.1.3<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care, 
                 random=~year+camp,
                 family ="poisson", data = Chicks[Chicks$sex == "Female",], prior = prior4, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Two way interactions

M4.2.1<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2,
                 random=~year+camp,
                 family ="poisson", data = Chicks[Chicks$sex == "Female",], prior = prior4, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M4.2.2<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2, 
                 random=~year+camp,
                 family ="poisson", data = Chicks[Chicks$sex == "Female",], prior = prior4, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M4.2.3<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2, 
                 random=~year+camp,
                 family ="poisson", data = Chicks[Chicks$sex == "Female",], prior = prior4, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Check convergence of models
M4.1.Sol<-mcmc.list(M4.1.1$Sol,M4.1.2$Sol,M4.1.3$Sol)
plot(M4.1.Sol)
M4.1.VCV<-mcmc.list(M4.1.1$VCV,M4.1.2$VCV,M4.1.3$VCV)
plot(M4.1.VCV)
#Point est. above 1.2 indicate convergence problems
gelman.diag(M4.1.Sol)
gelman.diag(M4.1.VCV, multivariate = FALSE)

M4.2.Sol<-mcmc.list(M4.2.1$Sol,M4.2.2$Sol,M4.2.3$Sol)
plot(M4.2.Sol)
M4.2.VCV<-mcmc.list(M4.2.1$VCV,M4.2.2$VCV,M4.2.3$VCV)
plot(M4.2.VCV)
gelman.diag(M4.2.Sol)
gelman.diag(M4.2.VCV, multivariate = FALSE)


#*******************************************************************************
#Model 5: Nest protection by group ----
#*******************************************************************************
prior5 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002)))

#Main effects
M5.1.1<-MCMCglmm(cbind(sitduration, obsduration - sitduration) ~ nomales-1+ Znonests + Znofemales + Znofemales2, 
                 random=~year+camp,
                 family ="multinomial2", data = PropSitEggCampData, prior = prior5, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M5.1.2<-MCMCglmm(cbind(sitduration, obsduration - sitduration) ~ nomales-1+ Znonests + Znofemales + Znofemales2, 
                 random=~year+camp,
                 family ="multinomial2", data = PropSitEggCampData, prior = prior5, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M5.1.3<-MCMCglmm(cbind(sitduration, obsduration - sitduration) ~ nomales-1+ Znonests + Znofemales + Znofemales2, 
                 random=~year+camp,
                 family ="multinomial2", data = PropSitEggCampData, prior = prior5, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Two-way interactions
M5.2.1<-MCMCglmm(cbind(sitduration, obsduration - sitduration) ~ nomales-1+ Znonests + nomales:Znofemales + nomales:Znofemales2,  
                 random=~year+camp,
                 family ="multinomial2", data = PropSitEggCampData, prior = prior5, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M5.2.2<-MCMCglmm(cbind(sitduration, obsduration - sitduration) ~ nomales-1+ Znonests + nomales:Znofemales + nomales:Znofemales2,  
                 random=~year+camp,
                 family ="multinomial2", data = PropSitEggCampData, prior = prior5, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M5.2.3<-MCMCglmm(cbind(sitduration, obsduration - sitduration) ~ nomales-1+ Znonests + nomales:Znofemales + nomales:Znofemales2,  
                 random=~year+camp,
                 family ="multinomial2", data = PropSitEggCampData, prior = prior5, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Check convergence of models
M5.1.Sol<-mcmc.list(M5.1.1$Sol,M5.1.2$Sol,M5.1.3$Sol)
plot(M5.1.Sol)
M5.1.VCV<-mcmc.list(M5.1.1$VCV,M5.1.2$VCV,M5.1.3$VCV)
plot(M5.1.VCV)
#Point est. above 1.2 indicate convergence problems
gelman.diag(M5.1.Sol)
gelman.diag(M5.1.VCV, multivariate = FALSE)

M5.2.Sol<-mcmc.list(M5.2.1$Sol,M5.2.2$Sol,M5.2.3$Sol)
plot(M5.2.Sol)
M5.2.VCV<-mcmc.list(M5.2.1$VCV,M5.2.2$VCV,M5.2.3$VCV)
plot(M5.2.VCV)
gelman.diag(M5.2.Sol)
gelman.diag(M5.2.VCV, multivariate = FALSE)

#*******************************************************************************
#Model 6: Hatching success ----
#*******************************************************************************

prior6 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002)))

#Main effects
M6.1.1<-MCMCglmm(cbind(hatched, eggslaid - hatched) ~ nomales-1 + car::logit(propsit) + ZlengthInc + Znonests + Znofemales + Znofemales2, 
                 random=~year+camp,
                 family ="multinomial2", data = PropSitEggCampData, prior = prior6, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M6.1.2<-MCMCglmm(cbind(hatched, eggslaid - hatched) ~ nomales-1 + car::logit(propsit) + ZlengthInc + Znonests + Znofemales + Znofemales2, 
                 random=~year+camp,
                 family ="multinomial2", data = PropSitEggCampData, prior = prior6, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M6.1.3<-MCMCglmm(cbind(hatched, eggslaid - hatched) ~ nomales-1 + car::logit(propsit) + ZlengthInc + Znonests + Znofemales + Znofemales2, 
                 random=~year+camp,
                 family ="multinomial2", data = PropSitEggCampData, prior = prior6, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Two-way interactions
M6.2.1<-MCMCglmm(cbind(hatched, eggslaid - hatched) ~ nomales-1 + car::logit(propsit) + ZlengthInc + Znonests + nomales:Znofemales + nomales:Znofemales2, 
                 random=~year+camp,
                 family ="multinomial2", data = PropSitEggCampData, prior = prior6, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M6.2.2<-MCMCglmm(cbind(hatched, eggslaid - hatched) ~ nomales-1 + car::logit(propsit) + ZlengthInc + Znonests + nomales:Znofemales + nomales:Znofemales2, 
                 random=~year+camp,
                 family ="multinomial2", data = PropSitEggCampData, prior = prior6, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M6.2.3<-MCMCglmm(cbind(hatched, eggslaid - hatched) ~ nomales-1 + car::logit(propsit) + ZlengthInc + Znonests + nomales:Znofemales + nomales:Znofemales2,
                 random=~year+camp,
                 family ="multinomial2", data = PropSitEggCampData, prior = prior6, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Check convergence of models
M6.1.Sol<-mcmc.list(M6.1.1$Sol,M6.1.2$Sol,M6.1.3$Sol)
plot(M6.1.Sol)
M6.1.VCV<-mcmc.list(M6.1.1$VCV,M6.1.2$VCV,M6.1.3$VCV)
plot(M6.1.VCV)
#Point est. above 1.2 indicate convergence problems
gelman.diag(M6.1.Sol)
gelman.diag(M6.1.VCV, multivariate = FALSE)

M6.2.Sol<-mcmc.list(M6.2.1$Sol,M6.2.2$Sol,M6.2.3$Sol)
plot(M6.2.Sol)
M6.2.VCV<-mcmc.list(M6.2.1$VCV,M6.2.2$VCV,M6.2.3$VCV)
plot(M6.2.VCV)
gelman.diag(M6.2.Sol)
gelman.diag(M6.2.VCV, multivariate = FALSE)

#*******************************************************************************
#Model 7: Male investment in incubation ----
#*******************************************************************************
prior7 = list(R = list(V=1, nu=0.002),G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002),G3=list(V=1, nu=0.002),G4=list(V=1, nu=0.002)))

#Main effects
M7.1.1<-MCMCglmm(cbind(sitdur1Nbird, totobsdurYear - sitdur1Nbird) ~ nomales-1 + Znofemales + Znofemales2, 
                 random=~year+camp+yearcamp+id,
                 family ="multinomial2", data = individuals2012.2018[individuals2012.2018$sex == "Male",], prior = prior7, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M7.1.2<-MCMCglmm(cbind(sitdur1Nbird, totobsdurYear - sitdur1Nbird) ~ nomales-1 + Znofemales + Znofemales2, 
                 random=~year+camp+yearcamp+id,
                 family ="multinomial2", data = individuals2012.2018[individuals2012.2018$sex == "Male",], prior = prior7, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M7.1.3<-MCMCglmm(cbind(sitdur1Nbird, totobsdurYear - sitdur1Nbird) ~ nomales-1 + Znofemales + Znofemales2, 
                 random=~year+camp+yearcamp+id,
                 family ="multinomial2", data = individuals2012.2018[individuals2012.2018$sex == "Male",], prior = prior7, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Two-way interactions
M7.2.1<-MCMCglmm(cbind(sitdur1Nbird, totobsdurYear - sitdur1Nbird) ~ nomales-1 + nomales:Znofemales + nomales:Znofemales2, 
                 random=~year+camp+yearcamp+id,
                 family ="multinomial2", data = individuals2012.2018[individuals2012.2018$sex == "Male",], prior = prior7, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M7.2.2<-MCMCglmm(cbind(sitdur1Nbird, totobsdurYear - sitdur1Nbird) ~ nomales-1 + nomales:Znofemales + nomales:Znofemales2,  
                 random=~year+camp+yearcamp+id,
                 family ="multinomial2", data = individuals2012.2018[individuals2012.2018$sex == "Male",], prior = prior7, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M7.2.3<-MCMCglmm(cbind(sitdur1Nbird, totobsdurYear - sitdur1Nbird) ~ nomales-1 + nomales:Znofemales + nomales:Znofemales2,  
                 random=~year+camp+yearcamp+id,
                 family ="multinomial2", data = individuals2012.2018[individuals2012.2018$sex == "Male",], prior = prior7, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Check convergence of models
M7.1.Sol<-mcmc.list(M7.1.1$Sol,M7.1.2$Sol,M7.1.3$Sol)
plot(M7.1.Sol)
M7.1.VCV<-mcmc.list(M7.1.1$VCV,M7.1.2$VCV,M7.1.3$VCV)
plot(M7.1.VCV)
#Point est. above 1.2 indicate convergence problems
gelman.diag(M7.1.Sol)
gelman.diag(M7.1.VCV, multivariate = FALSE)

M7.2.Sol<-mcmc.list(M7.2.1$Sol,M7.2.2$Sol,M7.2.3$Sol)
plot(M7.2.Sol)
M7.2.VCV<-mcmc.list(M7.2.1$VCV,M7.2.2$VCV,M7.2.3$VCV)
plot(M7.2.VCV)
gelman.diag(M7.2.Sol)
gelman.diag(M7.2.VCV, multivariate = FALSE)

#*******************************************************************************
#Model 8: Female investment in incubation ----
#*******************************************************************************
prior8 = list(R = list(V=1, nu=0.002),G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002),G3=list(V=1, nu=0.002),G4=list(V=1, nu=0.002)))

#Main effects
M8.1.1<-MCMCglmm(cbind(sitdur1Nbird, totobsdurYear - sitdur1Nbird) ~ nomales-1 + Znofemales + Znofemales2, 
                 random=~year+camp+yearcamp+id,
                 family ="multinomial2", data = individuals2012.2018[individuals2012.2018$sex == "Female",], prior = prior8, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M8.1.2<-MCMCglmm(cbind(sitdur1Nbird, totobsdurYear - sitdur1Nbird) ~ nomales-1 + Znofemales + Znofemales2, 
                 random=~year+camp+yearcamp+id,
                 family ="multinomial2", data = individuals2012.2018[individuals2012.2018$sex == "Female",], prior = prior8, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M8.1.3<-MCMCglmm(cbind(sitdur1Nbird, totobsdurYear - sitdur1Nbird) ~ nomales-1 + Znofemales + Znofemales2, 
                 random=~year+camp+yearcamp+id,
                 family ="multinomial2", data = individuals2012.2018[individuals2012.2018$sex == "Female",], prior = prior8, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Two-way interactions
M8.2.1<-MCMCglmm(cbind(sitdur1Nbird, totobsdurYear - sitdur1Nbird) ~ nomales-1 + nomales:Znofemales + nomales:Znofemales2, 
                 random=~year+camp+yearcamp+id,
                 family ="multinomial2", data = individuals2012.2018[individuals2012.2018$sex == "Female",], prior = prior8, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M8.2.2<-MCMCglmm(cbind(sitdur1Nbird, totobsdurYear - sitdur1Nbird) ~ nomales-1 + nomales:Znofemales + nomales:Znofemales2,  
                 random=~year+camp+yearcamp+id,
                 family ="multinomial2", data = individuals2012.2018[individuals2012.2018$sex == "Female",], prior = prior8, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M8.2.3<-MCMCglmm(cbind(sitdur1Nbird, totobsdurYear - sitdur1Nbird) ~ nomales-1 + nomales:Znofemales + nomales:Znofemales2,  
                 random=~year+camp+yearcamp+id,
                 family ="multinomial2", data = individuals2012.2018[individuals2012.2018$sex == "Female",], prior = prior8, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Check convergence of models
M8.1.Sol<-mcmc.list(M8.1.1$Sol,M8.1.2$Sol,M8.1.3$Sol)
plot(M8.1.Sol)
M8.1.VCV<-mcmc.list(M8.1.1$VCV,M8.1.2$VCV,M8.1.3$VCV)
plot(M8.1.VCV)
#Point est. above 1.2 indicate convergence problems
gelman.diag(M8.1.Sol)
gelman.diag(M8.1.VCV, multivariate = FALSE)

M8.2.Sol<-mcmc.list(M8.2.1$Sol,M8.2.2$Sol,M8.2.3$Sol)
plot(M8.2.Sol)
M8.2.VCV<-mcmc.list(M8.2.1$VCV,M8.2.2$VCV,M8.2.3$VCV)
plot(M8.2.VCV)
gelman.diag(M8.2.Sol)
gelman.diag(M8.2.VCV, multivariate = FALSE)

#*******************************************************************************
#Model 9: Number of interruptions to incubation ----
#*******************************************************************************
prior9 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002), G2=list(V=1, nu=0.002)))


#Main effects
M9.1.1<-MCMCglmm(int_rate ~ nomales-1 + Znofemales + Znofemales2,
                 random=~year + camp,
                 family ="poisson", data = PropSitEggCampDataSit, prior = prior9, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M9.1.2<-MCMCglmm(int_rate ~ nomales-1 + Znofemales + Znofemales2,
                 random=~year + camp,
                 family ="poisson", data = PropSitEggCampDataSit, prior = prior9, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M9.1.3<-MCMCglmm(int_rate ~ nomales-1 + Znofemales + Znofemales2,
                 random=~year + camp,
                 family ="poisson", data = PropSitEggCampDataSit, prior = prior9, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Two-way interactions
M9.2.1<-MCMCglmm(int_rate ~ nomales-1 + nomales:Znofemales + nomales:Znofemales2,
                 random=~year + camp,
                 family ="poisson", data = PropSitEggCampDataSit, prior = prior9, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M9.2.2<-MCMCglmm(int_rate ~ nomales-1 + nomales:Znofemales + nomales:Znofemales2,
                 random=~year + camp,
                 family ="poisson", data = PropSitEggCampDataSit, prior = prior9, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M9.2.3<-MCMCglmm(int_rate ~ nomales-1 + nomales:Znofemales + nomales:Znofemales2,
                 random=~year + camp,
                 family ="poisson", data = PropSitEggCampDataSit, prior = prior9, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Check convergence of models
M9.1.Sol<-mcmc.list(M9.1.1$Sol,M9.1.2$Sol,M9.1.3$Sol)
plot(M9.1.Sol)
M9.1.VCV<-mcmc.list(M9.1.1$VCV,M9.1.2$VCV,M9.1.3$VCV)
plot(M9.1.VCV)
#Point est. above 1.2 indicate convergence problems
gelman.diag(M9.1.Sol)
gelman.diag(M9.1.VCV, multivariate = FALSE)

M9.2.Sol<-mcmc.list(M9.2.1$Sol,M9.2.2$Sol,M9.2.3$Sol)
plot(M9.2.Sol)
M9.2.VCV<-mcmc.list(M9.2.1$VCV,M9.2.2$VCV,M9.2.3$VCV)
plot(M9.2.VCV)
gelman.diag(M9.2.Sol)
gelman.diag(M9.2.VCV, multivariate = FALSE)

#*******************************************************************************
#Model 10: Effect of the disparity in incubation on the number of interruptions ----
#*******************************************************************************
prior10 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002), G2=list(V=1, nu=0.002)))

#Main effects
M10.1.1<-MCMCglmm(int_rate ~ nomales:Diffpropsit-1,
                  random=~year + camp,
                  family ="poisson", data = PropSitEggCampDataSit, prior = prior10, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M10.1.2<-MCMCglmm(int_rate ~ nomales:Diffpropsit-1,
                  random=~year + camp,
                  family ="poisson", data = PropSitEggCampDataSit, prior = prior10, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M10.1.3<-MCMCglmm(int_rate ~ nomales:Diffpropsit-1,
                  random=~year + camp,
                  family ="poisson", data = PropSitEggCampDataSit, prior = prior10, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)


M10.1.Sol<-mcmc.list(M10.1.1$Sol,M10.1.2$Sol,M10.1.3$Sol)
plot(M10.1.Sol)
M10.1.VCV<-mcmc.list(M10.1.1$VCV,M10.1.2$VCV,M10.1.3$VCV)
plot(M10.1.VCV)
gelman.diag(M10.1.Sol)
gelman.diag(M10.1.VCV, multivariate = FALSE)

#*******************************************************************************
#Model 11: Effect of the disparity in incubation on the number of broken eggs ----
#*******************************************************************************
prior11 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002)))

#Main effects
M11.1.1<-MCMCglmm(cbind(brokeneggs, eggslaid - brokeneggs) ~ nomales:Diffpropsit-1, 
                  random=~year+camp,
                  family ="multinomial2", data = DiffInc, prior = prior11, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M11.1.2<-MCMCglmm(cbind(brokeneggs, eggslaid - brokeneggs) ~ nomales:Diffpropsit-1, 
                  random=~year+camp,
                  family ="multinomial2", data = DiffInc, prior = prior11, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M11.1.3<-MCMCglmm(cbind(brokeneggs, eggslaid - brokeneggs) ~ nomales:Diffpropsit-1, 
                  random=~year+camp,
                  family ="multinomial2", data = DiffInc, prior = prior11, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Check convergence of models
M11.1.Sol<-mcmc.list(M11.1.1$Sol,M11.1.2$Sol,M11.1.3$Sol)
plot(M11.1.Sol)
M11.1.VCV<-mcmc.list(M11.1.1$VCV,M11.1.2$VCV,M11.1.3$VCV)
plot(M11.1.VCV)
#Point est. above 1.2 indicate convergence problems
gelman.diag(M11.1.Sol)
gelman.diag(M11.1.VCV, multivariate = FALSE)

#*******************************************************************************
#Model 12: Effect of broken eggs on hatching success ----
#*******************************************************************************
prior12 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002)))

#Main effects
M12.1.1<-MCMCglmm(cbind(hatched, eggslaid - hatched) ~ logitpropbroken, 
                  random=~year+camp,
                  family ="multinomial2", data = PropSitEggCampData[!is.na(PropSitEggCampData$logitpropbroken),], prior = prior12, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M12.1.2<-MCMCglmm(cbind(hatched, eggslaid - hatched) ~ logitpropbroken, 
                  random=~year+camp,
                  family ="multinomial2", data = PropSitEggCampData[!is.na(PropSitEggCampData$logitpropbroken),], prior = prior12, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)
M12.1.3<-MCMCglmm(cbind(hatched, eggslaid - hatched) ~ logitpropbroken, 
                  random=~year+camp,
                  family ="multinomial2", data = PropSitEggCampData[!is.na(PropSitEggCampData$logitpropbroken),], prior = prior12, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Check convergence of models
M12.1.Sol<-mcmc.list(M12.1.1$Sol,M12.1.2$Sol,M12.1.3$Sol)
plot(M12.1.Sol)
M12.1.VCV<-mcmc.list(M12.1.1$VCV,M12.1.2$VCV,M12.1.3$VCV)
plot(M12.1.VCV)
#Point est. above 1.2 indicate convergence problems
gelman.diag(M12.1.Sol)
gelman.diag(M12.1.VCV, multivariate = FALSE)


#*******************************************************************************
#Model 13: Number of eggs produced by groups ----
#*******************************************************************************
prior13 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002)))

#Main effects
M13.1.1<-MCMCglmm(stand_eggs_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care, 
                  random=~year+camp,
                  family ="gaussian", data = GrpEggs, prior = prior13, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M13.1.2<-MCMCglmm(stand_eggs_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care, 
                  random=~year+camp,
                  family ="gaussian", data = GrpEggs, prior = prior13, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M13.1.3<-MCMCglmm(stand_eggs_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care, 
                  random=~year+camp,
                  family ="gaussian", data = GrpEggs, prior = prior13, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Two way interactions
M13.2.1<-MCMCglmm(stand_eggs_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2, 
                  random=~year+camp,
                  family ="gaussian", data = GrpEggs, prior = prior13, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M13.2.2<-MCMCglmm(stand_eggs_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2, 
                  random=~year+camp,
                  family ="gaussian", data = GrpEggs, prior = prior13, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M13.2.3<-MCMCglmm(stand_eggs_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2, 
                  random=~year+camp,
                  family ="gaussian", data = GrpEggs, prior = prior13, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)


#Check convergence of models
M13.1.Sol<-mcmc.list(M13.1.1$Sol,M13.1.2$Sol,M13.1.3$Sol)
plot(M13.1.Sol)
M13.1.VCV<-mcmc.list(M13.1.1$VCV,M13.1.2$VCV,M13.1.3$VCV)
plot(M13.1.VCV)
#Point est. above 1.2 indicate convergence problems
gelman.diag(M13.1.Sol)
gelman.diag(M13.1.VCV, multivariate = FALSE)

#*******************************************************************************
#Model 14: Number of chicks produced by groups ----
#*******************************************************************************
prior14 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002)))
#prior14 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002)))
#prior14 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=diag(2), nu=0.002)))

#Main effects
M14.1.1<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care, 
                  random=~year+camp,
                  family ="gaussian", data = GrpChicks, prior = prior14, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M14.1.2<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care, 
                  random=~year+camp,
                  family ="gaussian", data = GrpChicks, prior = prior14, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M14.1.3<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care, 
                  random=~year+camp,
                  family ="gaussian", data = GrpChicks, prior = prior14, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Two way interactions
M14.2.1<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2, 
                  random=~year+camp,
                  family ="gaussian", data = GrpChicks, prior = prior14, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M14.2.2<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2, 
                  random=~year+camp,
                  family ="gaussian", data = GrpChicks, prior = prior14, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M14.2.3<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2, 
                  random=~year+camp,
                  family ="gaussian", data = GrpChicks, prior = prior14, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Check convergence of models
M14.1.Sol<-mcmc.list(M14.1.1$Sol,M14.1.2$Sol,M14.1.3$Sol)
plot(M14.1.Sol)
M14.1.VCV<-mcmc.list(M14.1.1$VCV,M14.1.2$VCV,M14.1.3$VCV)
plot(M14.1.VCV)
#Point est. above 1.2 indicate convergence problems
gelman.diag(M14.1.Sol)
gelman.diag(M14.1.VCV, multivariate = FALSE)

M14.2.Sol<-mcmc.list(M14.2.1$Sol,M14.2.2$Sol,M14.2.3$Sol)
plot(M14.2.Sol)
M14.2.VCV<-mcmc.list(M14.2.1$VCV,M14.2.2$VCV,M14.2.3$VCV)
plot(M14.2.VCV)
gelman.diag(M14.2.Sol)
gelman.diag(M14.2.VCV, multivariate = FALSE)

#*******************************************************************************
#Model 15:  Male reproductive success: number of chicks produced vs average relatedness ----
#*******************************************************************************
prior15 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002)))

dat <- Chicks %>% filter(sex == "Male",nomales==3,!is.na(logitmale_rel))
  
ggplot(data=dat,aes(x=logitmale_rel,y=stand_chicks_poisson,fill=care))+
  geom_smooth(method="glm")+
  geom_jitter(size=4, shape=21, alpha = 0.8) +
  ylab("Chicks")+
  xlab("Relatedness")+
  facet_wrap(~nofemales)+t1

#Main effects
M15.1.1<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care + logitmale_rel, 
                  random=~year+camp,
                  family ="poisson", data = as.data.frame(dat), prior = prior15, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M15.1.2<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care + logitmale_rel, 
                  random=~year+camp,
                  family ="poisson", data = as.data.frame(dat), prior = prior15, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M15.1.3<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care + logitmale_rel, 
                  random=~year+camp,
                  family ="poisson", data = as.data.frame(dat), prior = prior15, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Two-way interactions
M15.2.1<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2 + care:logitmale_rel, 
                  random=~year+camp,
                  family ="poisson", data = as.data.frame(dat), prior = prior15, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M15.2.2<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2 + care:logitmale_rel, 
                  random=~year+camp,
                  family ="poisson", data = as.data.frame(dat), prior = prior15, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M15.2.3<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2 + care:logitmale_rel, 
                  random=~year+camp,
                  family ="poisson", data = as.data.frame(dat), prior = prior15, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Check convergence of models
M15.1.Sol<-mcmc.list(M15.1.1$Sol,M15.1.2$Sol,M15.1.3$Sol)
plot(M15.1.Sol)
M15.1.VCV<-mcmc.list(M15.1.1$VCV,M15.1.2$VCV,M15.1.3$VCV)
plot(M15.1.VCV)
#Point est. above 1.2 indicate convergence problems
gelman.diag(M15.1.Sol)
gelman.diag(M15.1.VCV, multivariate = FALSE)

M15.2.Sol<-mcmc.list(M15.2.1$Sol,M15.2.2$Sol,M15.2.3$Sol)
plot(M15.2.Sol)
M15.2.VCV<-mcmc.list(M15.2.1$VCV,M15.2.2$VCV,M15.2.3$VCV)
plot(M15.2.VCV)
gelman.diag(M15.2.Sol)
gelman.diag(M15.2.VCV, multivariate = FALSE)


#*******************************************************************************
#Model 16:  Female reproductive success: number of chicks produced ----
#*******************************************************************************
prior16 = list(R = list(V=1, nu=0.002), G = list(G1=list(V=1, nu=0.002),G2=list(V=1, nu=0.002)))

dat <- Chicks %>% filter(sex == "Female",nofemales>1,!is.na(logitfemale_rel))

ggplot(data=dat,aes(x=logitfemale_rel,y=stand_chicks_poisson,fill=care))+
  geom_smooth(method="glm")+
  geom_jitter(size=4, shape=21, alpha = 0.8) +
  ylab("Chicks")+
  xlab("Relatedness")+
  facet_wrap(~nomales+nofemales)+t1

#Main effects
M16.1.1<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care + logitfemale_rel, 
                  random=~year+camp,
                  family ="poisson", data = as.data.frame(dat), prior = prior16, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M16.1.2<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care + logitfemale_rel, 
                  random=~year+camp,
                  family ="poisson", data = as.data.frame(dat), prior = prior16, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M16.1.3<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + Znofemales:care + Znofemales2:care + logitfemale_rel, 
                  random=~year+camp,
                  family ="poisson", data = as.data.frame(dat), prior = prior16, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

#Two-way interactions
M16.2.1<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2+
                    care:logitfemale_rel, 
                  random=~year+camp,
                  family ="poisson", data = as.data.frame(dat), prior = prior16, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M16.2.2<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2+
                    care:logitfemale_rel, 
                  random=~year+camp,
                  family ="poisson", data = as.data.frame(dat), prior = prior16, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)

M16.2.3<-MCMCglmm(stand_chicks_poisson ~ nomales:care-1 + care:nomales:Znofemales + care:nomales:Znofemales2+
                    care:logitfemale_rel, 
                  random=~year+camp,
                  family ="poisson", data = as.data.frame(dat), prior = prior16, nitt=nitts, burnin=burn, thin=thin, verbose = FALSE)


#Check convergence of models
M16.1.Sol<-mcmc.list(M16.1.1$Sol,M16.1.2$Sol,M16.1.3$Sol)
plot(M16.1.Sol)
M16.1.VCV<-mcmc.list(M16.1.1$VCV,M16.1.2$VCV,M16.1.3$VCV)
plot(M16.1.VCV)
#Point est. above 1.2 indicate convergence problems
gelman.diag(M16.1.Sol)
gelman.diag(M16.1.VCV, multivariate = FALSE)


save.image("Data/Output/WrestlerModels_revision.RData")

# END